package com.example.tester

import android.content.Context
import android.print.PrintAttributes
import android.print.PrintManager
import android.webkit.WebView
import android.webkit.WebViewClient
import java.time.LocalDate
import java.time.format.DateTimeFormatter

object PDFManager {

    fun GenerarComprobantePDF(contexto: Context, reserva: Reserva) {
        // Creamos un WebView invisible para renderizar el HTML
        val webView = WebView(contexto)
        webView.webViewClient = object : WebViewClient() {
            override fun onPageFinished(view: WebView, url: String) {
                // Una vez cargado el HTML, lanzamos la impresión
                crearTrabajoImpresion(contexto, view, reserva.numeroHabitacion)
            }
        }
        val htmlContent = generarHtmlComprobante(reserva)
        webView.loadDataWithBaseURL(null, htmlContent, "text/HTML", "UTF-8", null)
    }

    private fun generarHtmlComprobante(reserva: Reserva): String {
        val formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy")
        val fechaActual = LocalDate.now().format(formatter)

        // HTML limpiado y formateado
        return """
            <html>
            <head>
                <style>
                    body { font-family: Helvetica, Arial, sans-serif; padding: 20px; }
                    .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #006495; padding-bottom: 10px; }
                    .titulo { font-size: 28px; font-weight: bold; color: #006495; }
                    .subtitulo { font-size: 16px; color: #555; margin-top: 5px; }
                    .tabla { width: 100%; border-collapse: collapse; margin-top: 20px; }
                    .tabla td { padding: 12px; border-bottom: 1px solid #e0e0e0; font-size: 14px; }
                    .label { font-weight: bold; width: 40%; color: #333; }
                    .valor { text-align: right; color: #000; }
                    .total-box { margin-top: 40px; padding: 15px; background-color: #f1f5f9; border-radius: 8px; text-align: right; }
                    .total-label { font-size: 14px; color: #555; }
                    .total-monto { font-size: 24px; font-weight: bold; color: #ba1a1a; }
                    .footer { margin-top: 60px; text-align: center; font-size: 10px; color: #888; border-top: 1px solid #eee; padding-top: 10px; }
                </style>
            </head>
            <body>
                <div class="header">
                    <div class="titulo">COMPROBANTE DE RESERVA</div>
                    <div class="subtitulo">Hotel Nazario • $fechaActual</div>
                </div>
                
                <table class="tabla">
                    <tr><td class="label">N° Habitación:</td><td class="valor">${reserva.numeroHabitacion}</td></tr>
                    <tr><td class="label">Categoría:</td><td class="valor">${reserva.tipoHabitacion}</td></tr>
                    <tr><td class="label">Huésped Titular:</td><td class="valor"><b>${reserva.nombreHuesped}</b></td></tr>
                    <tr><td class="label">Check-in:</td><td class="valor">${reserva.fechaEntrada}</td></tr>
                    <tr><td class="label">Check-out:</td><td class="valor">${reserva.fechaSalida}</td></tr>
                    <tr><td class="label">Precio x Noche:</td><td class="valor">S/. ${String.format("%.2f", reserva.precioNoche)}</td></tr>
                </table>

                <div class="total-box">
                    <div class="total-label">MONTO TOTAL A PAGAR</div>
                    <div class="total-monto">S/. ${String.format("%.2f", reserva.precioNoche)}</div>
                </div>

                <div class="footer">
                    Gracias por su preferencia. Este documento es un comprobante interno de reserva y no sustituye a una factura fiscal.
                </div>
            </body>
            </html>
        """.trimIndent()
    }

    private fun crearTrabajoImpresion(contexto: Context, webView: WebView, habitacion: Int) {
        val printManager = contexto.getSystemService(Context.PRINT_SERVICE) as? PrintManager
        val nombreTrabajo = "Reserva_Hab_${habitacion}_${System.currentTimeMillis()}"
        val printAdapter = webView.createPrintDocumentAdapter(nombreTrabajo)

        val builder = PrintAttributes.Builder()
        builder.setMediaSize(PrintAttributes.MediaSize.ISO_A4)

        printManager?.print(nombreTrabajo, printAdapter, builder.build())
    }
}