/*
 * Decompiled with CFR 0.152.
 */
package com.example.tester;

import android.content.Context;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.compose.runtime.internal.StabilityInferred;
import com.example.tester.Reserva;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/example/tester/PDFManager;", "", "<init>", "()V", "GenerarComprobantePDF", "", "contexto", "Landroid/content/Context;", "reserva", "Lcom/example/tester/Reserva;", "generarHtmlComprobante", "", "crearTrabajoImpresion", "webView", "Landroid/webkit/WebView;", "habitacion", "", "app_debug"})
@StabilityInferred(parameters=1)
public final class PDFManager {
    @NotNull
    public static final PDFManager INSTANCE = new PDFManager();
    public static final int $stable;

    private PDFManager() {
    }

    public final void GenerarComprobantePDF(@NotNull Context contexto, @NotNull Reserva reserva) {
        Intrinsics.checkNotNullParameter((Object)contexto, (String)"contexto");
        Intrinsics.checkNotNullParameter((Object)reserva, (String)"reserva");
        WebView webView = new WebView(contexto);
        webView.setWebViewClient(new WebViewClient(contexto, reserva){
            final /* synthetic */ Context $contexto;
            final /* synthetic */ Reserva $reserva;
            {
                this.$contexto = $contexto;
                this.$reserva = $reserva;
            }

            public void onPageFinished(WebView view, String url) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                PDFManager.access$crearTrabajoImpresion(PDFManager.INSTANCE, this.$contexto, view, this.$reserva.getNumeroHabitacion());
            }
        });
        String htmlContent = this.generarHtmlComprobante(reserva);
        webView.loadDataWithBaseURL(null, htmlContent, "text/HTML", "UTF-8", null);
    }

    private final String generarHtmlComprobante(Reserva reserva) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        String fechaActual = LocalDate.now().format(formatter);
        int n = reserva.getNumeroHabitacion();
        String string2 = reserva.getTipoHabitacion();
        String string3 = reserva.getNombreHuesped();
        String string4 = reserva.getFechaEntrada();
        String string5 = reserva.getFechaSalida();
        String string6 = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf(reserva.getPrecioNoche())};
        String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        string6 = "%.2f";
        objectArray = new Object[]{Float.valueOf(reserva.getPrecioNoche())};
        String string8 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
        return StringsKt.trimIndent((String)("\n            <html>\n            <head>\n                <style>\n                    body { font-family: Helvetica, Arial, sans-serif; padding: 20px; }\n                    .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #006495; padding-bottom: 10px; }\n                    .titulo { font-size: 28px; font-weight: bold; color: #006495; }\n                    .subtitulo { font-size: 16px; color: #555; margin-top: 5px; }\n                    .tabla { width: 100%; border-collapse: collapse; margin-top: 20px; }\n                    .tabla td { padding: 12px; border-bottom: 1px solid #e0e0e0; font-size: 14px; }\n                    .label { font-weight: bold; width: 40%; color: #333; }\n                    .valor { text-align: right; color: #000; }\n                    .total-box { margin-top: 40px; padding: 15px; background-color: #f1f5f9; border-radius: 8px; text-align: right; }\n                    .total-label { font-size: 14px; color: #555; }\n                    .total-monto { font-size: 24px; font-weight: bold; color: #ba1a1a; }\n                    .footer { margin-top: 60px; text-align: center; font-size: 10px; color: #888; border-top: 1px solid #eee; padding-top: 10px; }\n                </style>\n            </head>\n            <body>\n                <div class=\"header\">\n                    <div class=\"titulo\">COMPROBANTE DE RESERVA</div>\n                    <div class=\"subtitulo\">Hotel Nazario \u2022 " + fechaActual + "</div>\n                </div>\n                \n                <table class=\"tabla\">\n                    <tr><td class=\"label\">N\u00b0 Habitaci\u00f3n:</td><td class=\"valor\">" + n + "</td></tr>\n                    <tr><td class=\"label\">Categor\u00eda:</td><td class=\"valor\">" + string2 + "</td></tr>\n                    <tr><td class=\"label\">Hu\u00e9sped Titular:</td><td class=\"valor\"><b>" + string3 + "</b></td></tr>\n                    <tr><td class=\"label\">Check-in:</td><td class=\"valor\">" + string4 + "</td></tr>\n                    <tr><td class=\"label\">Check-out:</td><td class=\"valor\">" + string5 + "</td></tr>\n                    <tr><td class=\"label\">Precio x Noche:</td><td class=\"valor\">S/. " + string7 + "</td></tr>\n                </table>\n\n                <div class=\"total-box\">\n                    <div class=\"total-label\">MONTO TOTAL A PAGAR</div>\n                    <div class=\"total-monto\">S/. " + string8 + "</div>\n                </div>\n\n                <div class=\"footer\">\n                    Gracias por su preferencia. Este documento es un comprobante interno de reserva y no sustituye a una factura fiscal.\n                </div>\n            </body>\n            </html>\n        "));
    }

    private final void crearTrabajoImpresion(Context contexto, WebView webView, int habitacion) {
        block0: {
            Object object = contexto.getSystemService("print");
            PrintManager printManager = object instanceof PrintManager ? (PrintManager)object : null;
            String nombreTrabajo = "Reserva_Hab_" + habitacion + "_" + System.currentTimeMillis();
            PrintDocumentAdapter printDocumentAdapter = webView.createPrintDocumentAdapter(nombreTrabajo);
            Intrinsics.checkNotNullExpressionValue((Object)printDocumentAdapter, (String)"createPrintDocumentAdapter(...)");
            PrintDocumentAdapter printAdapter = printDocumentAdapter;
            PrintAttributes.Builder builder = new PrintAttributes.Builder();
            builder.setMediaSize(PrintAttributes.MediaSize.ISO_A4);
            PrintManager printManager2 = printManager;
            if (printManager2 == null) break block0;
            printManager2.print(nombreTrabajo, printAdapter, builder.build());
        }
    }

    public static final /* synthetic */ void access$crearTrabajoImpresion(PDFManager $this, Context contexto, WebView webView, int habitacion) {
        $this.crearTrabajoImpresion(contexto, webView, habitacion);
    }
}

